package gov.va.med.mhv.usermgmt.form;

import gov.va.med.mhv.usermgmt.transfer.FacilityInfo;
import gov.va.med.mhv.usermgmt.transfer.InPersonAuthentication;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.ActionMapping;
import org.tigris.atlas.messages.Message;
import org.tigris.atlas.messages.Messages;

/**
 * The InPersonAuthenticationForm class is responsible for handling user input.
 */
public class InPersonAuthenticationForm extends InPersonAuthenticationBaseForm {

	private String authenticatingFacilityErrorMessage;
	
	protected void doReset(ActionMapping mapping, HttpServletRequest request) {

	}
	
	public void copyFacilityToIPA(InPersonAuthentication ipa) {
		String id = getAuthenticatingFacility();
		
		if (!StringUtils.isBlank(id)) {
			FacilityInfo info = new FacilityInfo();
			info.setId(Long.parseLong(id));
			ipa.setAuthenticatingFacility(info);
		} else {
			ipa.setAuthenticatingFacility(null);
		}
	}
	
	public String getAuthenticatingFacilityErrorMessage() {
		return authenticatingFacilityErrorMessage;
	}

	public void populateFieldLevelMessages(Messages messages, HttpServletRequest request) {
		getMessages().addMessages(messages);
		setFieldLevelErrorMessages(messages, request);
		if (getMessages().getErrorMessageCount("authenticatingFacility") > 0) {
			Message message = (Message) messages.getErrorMessages("authenticatingFacility").iterator().next();
			authenticatingFacilityErrorMessage = getFieldLevelMessage(message, request);
		}
	}

}